/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.data.IWorldData;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.block.DeathCrateBlock;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.capability.PlayerDataProvider;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.init.Debuffs;
import dev.toma.gunsrpg.common.init.ModBlocks;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.init.WeaponDamageSource;
import dev.toma.gunsrpg.common.item.HammerItem;
import dev.toma.gunsrpg.common.item.ICustomUseDuration;
import dev.toma.gunsrpg.common.item.PointAwardItem;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.skills.AvengeMeFriendsSkill;
import dev.toma.gunsrpg.common.skills.SecondChanceSkill;
import dev.toma.gunsrpg.common.tileentity.DeathCrateTileEntity;
import dev.toma.gunsrpg.config.world.WorldConfiguration;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_SynchronizationPayloadPacket;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.world.LootStashes;
import dev.toma.gunsrpg.world.cap.WorldData;
import dev.toma.gunsrpg.world.cap.WorldDataProvider;
import dev.toma.gunsrpg.world.feature.ModConfiguredFeatures;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.TieredItem;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.forgespi.language.IModInfo;

@Mod.EventBusSubscriber(modid="gunsrpg")
public class CommonEventHandler {
    public static final Random random = new Random();
    private static final UUID MOVEMENT_SPEED = UUID.fromString("785168CE-6979-421A-ADE7-98461F04D1A0");
    private static final float SKILLBOOK_DROP_CHANCE = 0.02f;
    private static final float PERKBOOK_DROP_CHANCE = 0.1f;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void loadBiomes(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        MobSpawnInfoBuilder mobSpawnBuilder = event.getSpawns();
        WorldConfiguration config = GunsRPG.config.world;
        if (category != Biome.Category.OCEAN && category != Biome.Category.RIVER) {
            CommonEventHandler.addMonsterSpawn(mobSpawnBuilder, (EntityType)ModEntities.ZOMBIE_GUNNER.get(), config.mobConfig.zombieGunnerSpawn.choiceFromBiomeCategory(category), 1, 2);
            CommonEventHandler.addMonsterSpawn(mobSpawnBuilder, (EntityType)ModEntities.EXPLOSIVE_SKELETON.get(), config.mobConfig.grenadierSpawn.choiceFromBiomeCategory(category), 1, 2);
            CommonEventHandler.addMonsterSpawn(mobSpawnBuilder, (EntityType)ModEntities.ZOMBIE_KNIGHT.get(), config.mobConfig.zombieKnightSpawn.choiceFromBiomeCategory(category), 1, 2);
            CommonEventHandler.addMonsterSpawn(mobSpawnBuilder, (EntityType)ModEntities.ZOMBIE_NIGHTMARE.get(), config.mobConfig.zombieNightmareSpawn.choiceFromBiomeCategory(category), 1, 2);
        }
        if (category != Biome.Category.NETHER && category != Biome.Category.THEEND) {
            if (category != Biome.Category.OCEAN && category != Biome.Category.RIVER) {
                builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ModConfiguredFeatures.LOOT_STASH);
            }
            for (ConfiguredFeature<?, ?> feature : ModConfiguredFeatures.getOres()) {
                builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature);
            }
        } else {
            CommonEventHandler.addMonsterSpawn(mobSpawnBuilder, (EntityType)ModEntities.ROCKET_ANGEL.get(), config.mobConfig.rocketAngelSpawn.choiceFromBiomeCategory(category), 1, 2);
            mobSpawnBuilder.func_242573_a((EntityType)ModEntities.ROCKET_ANGEL.get(), 0.7, 0.15);
        }
    }

    @SubscribeEvent
    public static void playSoundAtEntity(PlaySoundAtEntityEvent event) {
        if (event.getSound() == SoundEvents.field_187719_p) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(GunsRPG.makeResource("playerdata"), (ICapabilityProvider)new PlayerDataProvider((PlayerEntity)entity));
        }
    }

    @SubscribeEvent
    public static void attachLevelCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(GunsRPG.makeResource("worldcap"), (ICapabilityProvider)new WorldDataProvider((World)event.getObject()));
    }

    @SubscribeEvent
    public static void onLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        NetworkManager.sendClientPacket(serverPlayer, S2C_SynchronizationPayloadPacket.makePayloadPacket());
        PlayerData.get(player).ifPresent(data -> {
            data.sync(-1);
            data.getProgressData().onLogIn();
            ModList list = ModList.get();
            Optional optional = list.getModContainerById("gunsrpg");
            optional.ifPresent(container -> {
                VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)container.getModInfo());
                switch (result.status) {
                    case OUTDATED: 
                    case BETA_OUTDATED: {
                        String target = result.target.getCanonical();
                        String url = "https://www.curseforge.com/minecraft/mc-mods/guns-rpg/files";
                        StringTextComponent message = new StringTextComponent(TextFormatting.YELLOW + "GunsRPG: " + TextFormatting.RED + "out-of-date");
                        StringTextComponent link = new StringTextComponent(TextFormatting.YELLOW + "Version " + target + " is available for download " + TextFormatting.BOLD + "HERE");
                        Style style = link.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                        link.func_230530_a_(style);
                        player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
                        player.func_145747_a((ITextComponent)link, Util.field_240973_b_);
                    }
                }
            });
        });
    }

    @SubscribeEvent
    public static void getDestructionSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        PlayerData.get(player).ifPresent(data -> {
            IAttributeProvider provider = data.getAttributes();
            if (stack.func_77973_b() instanceof AxeItem) {
                CommonEventHandler.editMiningSpeed(event, provider, Attribs.WOODCUTTING_SPEED);
            } else if (stack.func_77973_b() instanceof PickaxeItem) {
                CommonEventHandler.editMiningSpeed(event, provider, Attribs.MINING_SPEED);
            } else if (stack.func_77973_b() instanceof ShovelItem) {
                CommonEventHandler.editMiningSpeed(event, provider, Attribs.DIGGING_SPEED);
            }
        });
    }

    @SubscribeEvent
    public static void finishEating(LivingEntityUseItemEvent.Finish event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            PlayerData.get(player).ifPresent(data -> {
                IDebuffs debuffs = data.getDebuffControl();
                ItemStack usedItem = event.getItem();
                Random random = player.func_70681_au();
                if (usedItem.func_77973_b() == Items.field_151078_bh) {
                    if (!debuffs.hasDebuff(Debuffs.INFECTION) && random.nextFloat() < 0.3f) {
                        debuffs.toggle(Debuffs.INFECTION);
                    }
                } else if (usedItem.func_77973_b() == Items.field_151070_bp && !debuffs.hasDebuff(Debuffs.POISON) && random.nextFloat() < 0.4f) {
                    debuffs.toggle(Debuffs.POISON);
                }
            });
        }
    }

    @SubscribeEvent
    public static void disableShield(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player;
        ItemStack mainHand;
        if (event.getHand() == Hand.OFF_HAND && (mainHand = (player = event.getPlayer()).func_184614_ca()).func_77973_b() instanceof GunItem) {
            event.setCancellationResult(ActionResultType.FAIL);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEat(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            int nutrition;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack stack = event.getItem();
            Item item = stack.func_77973_b();
            Food food = item.func_219967_s();
            if (food != null && !player.field_70170_p.field_72995_K && (nutrition = food.func_221466_a()) >= GunsRPG.config.skills.wellFedTriggerValue) {
                PlayerData.get(player).ifPresent(data -> {
                    ISkillProvider provider = data.getSkillProvider();
                    if (provider.hasSkill(Skills.WELL_FED_I)) {
                        SkillUtil.getTopHierarchySkill(Skills.WELL_FED_I, provider).applyEffects(player, (IPlayerData)data);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        PlayerInteractionManager interaction = player.field_71134_c;
        ItemStack stack = player.func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int silk = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack);
        World world = (World)event.getWorld();
        BlockState blockState = event.getState();
        if (stack.func_77973_b() instanceof HammerItem) {
            HammerItem hammer = (HammerItem)stack.func_77973_b();
            if (hammer.func_150893_a(stack, blockState) > 1.0f) {
                Direction facing = ModUtils.getFacing((PlayerEntity)player);
                boolean creative = interaction.func_73083_d();
                for (BlockPos pos : hammer.gatherBlocks(event.getPos(), facing)) {
                    BlockState state = world.func_180495_p(pos);
                    boolean harvestable = hammer.canHarvestBlock(stack, state);
                    if (!harvestable || !(state.func_185887_b((IBlockReader)world, pos) >= 0.0f)) continue;
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                    if (creative) {
                        CommonEventHandler.removeBlockAt(pos, false, world, (PlayerEntity)player);
                        continue;
                    }
                    ItemStack itemStack = stack.func_77946_l();
                    stack.func_179548_a(world, state, pos, (PlayerEntity)player);
                    if (stack.func_190926_b() && !itemStack.func_190926_b()) {
                        ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemStack, (Hand)Hand.MAIN_HAND);
                    }
                    boolean mined = CommonEventHandler.removeBlockAt(pos, true, world, (PlayerEntity)player);
                    Block block = state.func_177230_c();
                    if (mined) {
                        block.func_180657_a(world, (PlayerEntity)player, pos, state, world.func_175625_s(pos), itemStack);
                        int xpDrop = state.getExpDrop((IWorldReader)world, pos, fortune, silk);
                        if (xpDrop > 0) {
                            block.func_180637_b((ServerWorld)world, pos, xpDrop);
                        }
                    }
                    if (stack.func_77952_i() != stack.func_77958_k()) {
                        continue;
                    }
                    break;
                }
            }
        } else if (blockState.func_185904_a() == Material.field_151592_s && stack.func_190926_b() && !world.field_72995_K) {
            PlayerData.get((PlayerEntity)player).ifPresent(data -> {
                IDebuffs debuffs = data.getDebuffControl();
                if (!debuffs.hasDebuff(Debuffs.BLEED) && world.field_73012_v.nextFloat() < 0.5f) {
                    debuffs.toggle(Debuffs.BLEED);
                }
            });
        }
    }

    private static boolean removeBlockAt(BlockPos pos, boolean harvest, World level, PlayerEntity player) {
        BlockState state = level.func_180495_p(pos);
        boolean removed = state.removedByPlayer(level, pos, player, harvest, level.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)level, pos, state);
        }
        return removed;
    }

    @SubscribeEvent
    public static void damageEntity(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        if (source.func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            PlayerData.get(player).ifPresent(data -> {
                IAttributeProvider provider = data.getAttributes();
                LivingEntity entity = event.getEntityLiving();
                float health = entity.func_110138_aP();
                boolean instantKill = false;
                boolean isMeleeItem = player.func_184614_ca().func_77973_b() instanceof TieredItem;
                if (health < 256.0f && isMeleeItem && GunsRPG.config.skills.isInstantKillAllowed(entity.func_200600_R())) {
                    boolean b;
                    float f = random.nextFloat();
                    boolean bl = b = (double)f < provider.getAttributeValue(Attribs.INSTANT_KILL);
                    if (b) {
                        event.setAmount(entity.func_110143_aJ());
                        instantKill = true;
                    }
                }
                if (!instantKill && isMeleeItem) {
                    float amount = event.getAmount() + provider.getAttribute(Attribs.MELEE_DAMAGE).floatValue();
                    event.setAmount(amount);
                }
            });
        } else if (source.func_76364_f() instanceof AbstractArrowEntity && source.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            PlayerData.get(player).ifPresent(data -> {
                IAttributeProvider attributeProvider = data.getAttributes();
                double amount = event.getAmount();
                event.setAmount((float)(amount *= attributeProvider.getAttributeValue(Attribs.BOW_DAMAGE)));
            });
        }
    }

    @SubscribeEvent
    public static void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity player = event.getPlayer();
        PlayerData.get(player).ifPresent(data -> data.sync(-1));
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        LazyOptional<IPlayerData> oldDataOptional = PlayerData.get(event.getOriginal());
        LazyOptional<IPlayerData> freshDataOptional = PlayerData.get(event.getPlayer());
        int flag = -1;
        oldDataOptional.ifPresent(oldData -> freshDataOptional.ifPresent(freshData -> freshData.fromNbt(oldData.toNbt(flag), flag)));
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingHurtEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            PlayerData.get(player).ifPresent(data -> {
                float amount = event.getAmount();
                DamageSource source = event.getSource();
                IAttributeProvider provider = data.getAttributes();
                amount *= provider.getAttribute(Attribs.DAMAGE_TAKEN).floatValue();
                if (source == DamageSource.field_76379_h) {
                    amount *= provider.getAttribute(Attribs.FALL_DAMAGE).floatValue();
                }
                if (amount > 1.0f) {
                    IDebuffs debuffs = data.getDebuffControl();
                    IDebuffContext context = IDebuffContext.of(source, player, data, amount);
                    debuffs.trigger(IDebuffType.TriggerFlags.HURT, context, null);
                }
                event.setAmount(amount);
            });
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        PlayerEntity player;
        DamageSource damageSource = event.getSource();
        Entity directSource = damageSource.func_76346_g();
        if (directSource instanceof PlayerEntity) {
            player = (PlayerEntity)directSource;
            ItemStack killWeapon = damageSource instanceof WeaponDamageSource ? ((WeaponDamageSource)damageSource).getKillWeapon() : player.func_184614_ca();
            Entity victim = event.getEntity();
            PlayerData.get(player).ifPresent(data -> data.getProgressData().onEnemyKilled(victim, killWeapon));
        }
        if (event.getEntity() instanceof IMob && !(event.getEntity() instanceof SlimeEntity) && !event.getEntity().field_70170_p.field_72995_K) {
            Entity entity = event.getEntity();
            PointAwardItem item = null;
            float chance = random.nextFloat();
            float skillChance = 0.02f;
            float perkChance = 0.1f;
            if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player2 = (PlayerEntity)event.getSource().func_76346_g();
                IPlayerData data2 = PlayerData.getUnsafe(player2);
                IAttributeProvider provider = data2.getAttributes();
                skillChance *= provider.getAttribute(Attribs.SKILL_BOOK_CHANCE).floatValue();
                perkChance *= provider.getAttribute(Attribs.PERK_BOOK_CHANCE).floatValue();
            }
            perkChance += skillChance;
            if (chance < skillChance) {
                item = ModItems.SKILLPOINT_BOOK;
            } else if (chance < perkChance) {
                item = ModItems.PERKPOINT_BOOK;
            }
            if (item != null) {
                entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new ItemStack((IItemProvider)item)));
            }
        }
        if (event.getEntity() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getEntity();
            PlayerData.get(player).ifPresent(data -> {
                SecondChanceSkill secondChanceSkill;
                ISkillProvider provider = data.getSkillProvider();
                if (provider.hasSkill(Skills.SECOND_CHANCE_I) && (secondChanceSkill = SkillUtil.getTopHierarchySkill(Skills.SECOND_CHANCE_I, provider)).canApply(player)) {
                    event.setCanceled(true);
                    secondChanceSkill.setOnCooldown();
                    secondChanceSkill.onUse(player);
                    data.sync(2);
                }
                if (!event.isCanceled()) {
                    AvengeMeFriendsSkill avengeSkill;
                    data.getDebuffControl().clearActive();
                    if (GunsRPG.config.world.createCrateOnPlayerDeath && !player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && !player.field_71071_by.func_191420_l()) {
                        BlockPos.Mutable pos = player.func_233580_cy_().func_239590_i_();
                        Direction[] relative = (Direction[])Direction.Plane.HORIZONTAL.func_239636_a_().toArray(Direction[]::new);
                        World world = player.field_70170_p;
                        GunsRPG.log.debug(DeathCrateBlock.MARKER, "Generating death crate for {}", (Object)player);
                        block0: while (pos.func_177956_o() < 255 && !world.func_175623_d((BlockPos)pos)) {
                            for (Direction direction : relative) {
                                BlockPos relativePos = pos.func_177972_a(direction);
                                if (!world.func_175623_d(relativePos)) continue;
                                pos = relativePos.func_239590_i_();
                                break block0;
                            }
                            pos.func_185336_p(pos.func_177956_o() + 1);
                        }
                        GunsRPG.log.debug(DeathCrateBlock.MARKER, "Death crate location found at {}", (Object)pos);
                        if (pos != null) {
                            GunsRPG.log.debug(DeathCrateBlock.MARKER, "Creating death crate at {}", (Object)pos);
                            BlockPos position = pos.func_185334_h();
                            world.func_180501_a(position, ModBlocks.DEATH_CRATE.func_176223_P(), 3);
                            TileEntity tileEntity = world.func_175625_s(position);
                            GunsRPG.log.debug(DeathCrateBlock.MARKER, "Preparing death crate item transfer to inventory {}", (Object)tileEntity);
                            if (tileEntity instanceof DeathCrateTileEntity) {
                                ((DeathCrateTileEntity)tileEntity).fillInventory(player);
                                GunsRPG.log.debug(DeathCrateBlock.MARKER, "Filled death crate inventory");
                            }
                        }
                    }
                    if ((avengeSkill = provider.getSkill(Skills.AVENGE_ME_FRIENDS)) != null) {
                        avengeSkill.applyEffects(player);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void respawnPlayer(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        PlayerData.get(player).ifPresent(data -> {
            ISkillProvider provider = data.getSkillProvider();
            if (provider.hasSkill(Skills.WAR_MACHINE)) {
                provider.getSkill(Skills.WAR_MACHINE).onPurchase(player);
            }
            if (!event.isEndConquered()) {
                data.getDebuffControl().trigger(IDebuffType.TriggerFlags.RESPAWN, IDebuffContext.of(DamageSource.field_76377_j, player, data, 0.0f), null);
            }
            data.sync(-1);
        });
    }

    @SubscribeEvent
    public static void getLootingLevel(LootingLevelEvent event) {
        WeaponDamageSource source;
        Entity projectile;
        DamageSource damageSource = event.getDamageSource();
        if (damageSource instanceof WeaponDamageSource && (projectile = (source = (WeaponDamageSource)damageSource).func_76364_f()) instanceof AbstractProjectile) {
            AbstractProjectile abstractProjectile = (AbstractProjectile)projectile;
            int lootLevel = abstractProjectile.getProperty(Properties.LOOT_LEVEL);
            event.setLootingLevel(lootLevel);
        }
    }

    @SubscribeEvent
    public static void checkEntitySpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.isSpawner() && GunsRPG.config.world.mobConfig.disableMobSpawners) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PlayerEntity player = event.player;
            PlayerData.get(player).ifPresent(data -> {
                data.tick();
                CommonEventHandler.updateMovementSpeedAttribute(player, data.getAttributes());
            });
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        IWorldData cap = WorldData.get(event.world);
        if (cap == null) {
            return;
        }
        cap.tick(event.world);
    }

    @SubscribeEvent
    public static void trySleepInBed(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (!player.field_70170_p.func_72935_r()) {
            PlayerEntity.SleepResult result;
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
                serverplayer.func_242111_a(serverplayer.field_70170_p.func_234923_W_(), pos.func_177984_a(), serverplayer.field_70177_z, true, false);
            }
            if ((result = GunsRPG.config.world.sleepRestriction.getResult(player.field_70170_p)) != null) {
                event.setResult(result);
            }
        }
    }

    @SubscribeEvent
    public static void loadLootTables(LootTableLoadEvent event) {
        String loottable = event.getName().toString();
        if (loottable.equals("minecraft:chests/abandoned_mineshaft") || loottable.equals("minecraft:chests/desert_pyramid") || loottable.equals("minecraft:chests/simple_dungeon") || loottable.equals("minecraft:chests/village_blacksmith")) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.SKILLPOINT_BOOK).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 3.0f)))).func_216046_a((IRandomRange)new ConstantRange(1)).bonusRolls(0.0f, 0.0f).func_216044_b());
        }
    }

    @SubscribeEvent
    public static void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerWorld world = server.func_71218_a(World.field_234918_g_);
        LootStashes.tick(world);
    }

    @SubscribeEvent
    public static void rightClickInteract(PlayerInteractEvent.RightClickBlock event) {
        CommonEventHandler.cancelIfPlayerHoldsGun((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void rightClickEntityInteract(PlayerInteractEvent.EntityInteract event) {
        CommonEventHandler.cancelIfPlayerHoldsGun((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void rightClickEntitySpecificInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        CommonEventHandler.cancelIfPlayerHoldsGun((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        CommonEventHandler.cancelIfPlayerHoldsGun((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        ItemStack stack = event.getItem();
        LivingEntity entity = event.getEntityLiving();
        if (stack.func_77973_b() instanceof ICustomUseDuration && entity instanceof PlayerEntity) {
            ICustomUseDuration useDuration = (ICustomUseDuration)stack.func_77973_b();
            PlayerEntity player = (PlayerEntity)entity;
            int defaultDuration = event.getDuration();
            event.setDuration(useDuration.getUseDuration(defaultDuration, stack, player));
        }
    }

    private static void cancelIfPlayerHoldsGun(PlayerInteractEvent event) {
        if (event.getPlayer().func_184614_ca().func_77973_b() instanceof AbstractGun) {
            event.setCanceled(true);
        }
    }

    private static void editMiningSpeed(PlayerEvent.BreakSpeed event, IAttributeProvider provider, IAttributeId attributeId) {
        float baseSpeed = event.getOriginalSpeed();
        if (baseSpeed > 1.0f) {
            float multiplier = provider.getAttribute(attributeId).floatValue();
            float newSpeed = baseSpeed * multiplier;
            event.setNewSpeed(newSpeed);
        }
    }

    private static void updateMovementSpeedAttribute(PlayerEntity player, IAttributeProvider provider) {
        double requiredValue;
        ModifiableAttributeInstance instance = player.func_110148_a(Attributes.field_233821_d_);
        AttributeModifier modifier = instance.func_111127_a(MOVEMENT_SPEED);
        double modifierValue = modifier == null ? 0.0 : modifier.func_111164_d();
        if (modifierValue != (requiredValue = 1.0 - provider.getAttributeValue(Attribs.MOVEMENT_SPEED))) {
            AttributeModifier newModifier = new AttributeModifier(MOVEMENT_SPEED, "attribute", requiredValue, AttributeModifier.Operation.MULTIPLY_TOTAL);
            instance.func_188479_b(MOVEMENT_SPEED);
            instance.func_233767_b_(newModifier);
        }
    }

    private static void addMonsterSpawn(MobSpawnInfoBuilder builder, EntityType<?> type, int weight, int groupMin, int groupMax) {
        if (weight <= 0) {
            return;
        }
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(type, weight, groupMin, groupMax));
    }
}

